/**
 * KareeRise Job Extension - Configuration
 *
 * Shared configuration constants for the extension
 */

// Server configuration
window.KareeRiseConfig = {
    SERVER_URL: "https://kareerise.com",
    BACKUP_URLS: [
        "https://kareerise.com",
        "https://www.kareerise.com",
        "http://localhost:3000",
        "http://127.0.0.1:3000"
    ],

    // Extension settings
    TIMEOUT_MS: 60000,
    RETRY_ATTEMPTS: 3,

    // API endpoints
    ENDPOINTS: {
        CURRENT_USER: "/api/user/current",
        TEST_EXTENSION: "/api/test-extension",
        AI_EXTRACT: "/api/extensions/ai-extract",
        DIRECT_ADD: "/api/extensions/direct-add",
        APPLICATIONS: "/applications",
        LOGIN: "/auth/login?returnTo=/applications",
    },
};

console.log(
    `🔧 KareeRise Extension Config loaded: ${window.KareeRiseConfig.SERVER_URL}`
);
