# KareeRise Job Importer

A browser extension that allows you to easily import job postings from LinkedIn, Indeed, and other job boards directly to your KareeRise account with a single click. This version automatically adds jobs to your applications without requiring any additional steps.

## Features

- One-click job importing from LinkedIn, Indeed, Glassdoor, and other job boards
- Automatically extracts job details including title, company, location, and description
- Direct integration - jobs are added immediately to your applications
- Works across major browsers (Chrome, Edge, Firefox)
- Simple, clean interface with a floating button
- Shows detailed notifications of the import process
- Clickable success button that links to the added job
- Duplicate job detection to prevent multiple entries
- Improved authentication handling and error recovery

## Quick Start

1. **Configure**: Edit `js/content.js` and set your KareeRise URL in the `SERVER_URL` variable
2. **Install**: Load the extension in your browser (see Installation section below)
3. **Use**: Visit LinkedIn job pages and click the "Add to KareeRise" button

## How It Works

This extension uses a direct approach to add jobs to your applications:

1. It detects when you're viewing a job posting on LinkedIn, Indeed, or other supported job boards
2. It adds a floating "Add to KareeRise" button to the page
3. When clicked, it extracts job data from the current page using site-specific extraction rules
4. It makes direct API calls to your KareeRise server to add the job to your applications
5. It shows progress notifications throughout the process
6. On success, the button turns green and becomes clickable to view the job

The extension includes advanced mechanisms:
- Cookie authentication handling to maintain your session
- Multiple server URL fallbacks to maximize connectivity options
- Automatic retry with alternative endpoints if a connection fails
- Intelligent duplicate detection to prevent adding the same job multiple times
- Clear authentication error messaging with one-click login capability

## Installation

### Standard Installation (Coming Soon)
The extension will soon be available in the Chrome Web Store and other browser extension marketplaces.

### Developer Installation
1. Open Chrome or Edge and navigate to `chrome://extensions/` or `edge://extensions/`
2. Enable "Developer mode" using the toggle in the top-right corner
3. Click "Load unpacked" and select this directory
4. The extension is now installed and will be active on supported job board pages

For detailed installation instructions for all browsers, see [DEVELOPER-INSTALLATION.md](./DEVELOPER-INSTALLATION.md)

## Configuration

The extension is configured to connect to `https://kareerise.com` by default. For local development:

1. Open the `js/content.js` file
2. Locate the `SERVER_URL` constant at the top of the file
3. Change it to your local server URL (e.g., `http://localhost:3000`)
4. Update the `BACKUP_SERVER_URLS` array if needed
5. Save the file and reload the extension in your browser

## Requirements

- Your KareeRise server must have CORS properly configured (included in standard deployment)
- The user must be logged into KareeRise in the same browser
- The user must have at least one profile in their KareeRise account

## Documentation

This repository contains the following documentation:

- [DEVELOPER-INSTALLATION.md](./DEVELOPER-INSTALLATION.md) - How to install the extension in developer mode
- [USER-GUIDE.md](./USER-GUIDE.md) - Instructions on how to use the extension
- [EDGE_NOTE.md](./EDGE_NOTE.md) - Special notes for Microsoft Edge users

## Version History

- **1.2** - Fixed cookie domain handling and authentication
- **1.1** - Added support for additional job boards and improved error handling
- **1.0** - Initial release with basic LinkedIn support

## Support

For support with this extension, please contact your KareeRise administrator or create an issue in the GitHub repository.